<?php $__env->startSection('title', 'ENT Care Center - Expert Ear, Nose, and Throat Medical Services'); ?>
<?php $__env->startSection('meta_description', 'ENT Care Center provides expert medical care for ear, nose, and throat conditions. Book your appointment today!'); ?>

<?php $__env->startSection('content'); ?>
<!-- Hero Section with Background -->
<section class="relative min-h-[85vh] flex items-center justify-center overflow-hidden bg-white">
    <!-- Background Slider -->
    <!-- Background Gradient -->
    <div class="absolute inset-0 bg-gradient-to-br from-primary-900 via-purple-900 to-accent-900"></div>

    <!-- Animated Shapes (Overlaid) -->
    <div class="absolute top-20 left-10 w-64 h-64 bg-primary-200/30 rounded-full blur-3xl animate-pulse-slow"></div>
    <div class="absolute bottom-20 right-10 w-96 h-96 bg-accent-200/30 rounded-full blur-3xl animate-pulse-slow" style="animation-delay: 1s;"></div>
    
    <!-- Content -->
    <div class="relative z-10 max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
        <div x-data="{ loaded: false }" 
             x-init="setTimeout(() => loaded = true, 100)"
             :class="{'opacity-0 translate-y-10': !loaded, 'opacity-100 translate-y-0': loaded}"
             class="transition-all duration-1000">
             
            <span class="inline-block px-4 py-1.5 mb-6 text-sm font-semibold tracking-wider text-primary-100 uppercase bg-white/10 backdrop-blur-sm rounded-full border border-white/20 shadow-sm">
                World-Class Healthcare
            </span>
            
            <h1 class="text-5xl sm:text-6xl md:text-7xl font-bold text-white mb-8 leading-tight tracking-tight drop-shadow-lg">
                Expert <span class="bg-clip-text text-transparent bg-gradient-to-r from-primary-400 to-accent-300">ENT Care</span><br>
                You Can Trust
            </h1>
            
            <p class="text-xl md:text-2xl text-slate-100 mb-10 max-w-3xl mx-auto leading-relaxed font-light drop-shadow-md">
                Comprehensive ear, nose, and throat medical services tailored to your needs. Experience excellence in healthcare with our dedicated specialists.
            </p>
            
            <div class="flex flex-col sm:flex-row gap-5 justify-center items-center">
                <a href="<?php echo e(route('appointment.create')); ?>" 
                   class="group px-8 py-4 bg-primary-600 text-white rounded-xl font-semibold text-lg shadow-lg shadow-primary-900/50 hover:bg-primary-500 hover:shadow-primary-900/60 hover:-translate-y-1 transition-all duration-300 flex items-center space-x-2">
                    <span>Book Appointment</span>
                    <svg class="w-5 h-5 group-hover:translate-x-1 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3"></path>
                    </svg>
                </a>
                <a href="<?php echo e(route('services.index')); ?>" 
                   class="px-8 py-4 bg-white/10 backdrop-blur-sm text-white border border-white/30 rounded-xl font-semibold text-lg hover:bg-white/20 hover:border-white/50 transition-all duration-300 shadow-sm hover:shadow-md">
                    Our Services
                </a>
            </div>
        </div>
    </div>
</section>

<!-- Statistics Section -->
<section x-data="{ 
    animated: false,
    countUp(value, suffix = '') {
        if (!this.animated) return '0' + suffix;
        return value + suffix;
    }
}" 
         x-intersect="animated = true"
         class="py-12 bg-white border-y border-secondary-100">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="grid grid-cols-2 md:grid-cols-4 gap-8">
            <div class="text-center group">
                <div class="text-4xl md:text-5xl font-bold text-primary-600 mb-2 group-hover:scale-110 transition-transform duration-300" x-text="animated ? '25' : '25'"></div>
                <div class="text-sm font-medium text-secondary-500 uppercase tracking-wide">Years of Experience</div>
            </div>
            <div class="text-center group">
                <div class="text-4xl md:text-5xl font-bold text-primary-600 mb-2 group-hover:scale-110 transition-transform duration-300" x-text="animated ? '15' : '15'"></div>
                <div class="text-sm font-medium text-secondary-500 uppercase tracking-wide">Expert Doctors</div>
            </div>
            <div class="text-center group">
                <div class="text-4xl md:text-5xl font-bold text-primary-600 mb-2 group-hover:scale-110 transition-transform duration-300" x-text="animated ? '10K+' : '10K+'"></div>
                <div class="text-sm font-medium text-secondary-500 uppercase tracking-wide">Happy Patients</div>
            </div>
            <div class="text-center group">
                <div class="text-4xl md:text-5xl font-bold text-primary-600 mb-2 group-hover:scale-110 transition-transform duration-300" x-text="animated ? '20+' : '20'"></div>
                <div class="text-sm font-medium text-secondary-500 uppercase tracking-wide">Services Offered</div>
            </div>
        </div>
    </div>
</section>

<!-- Welcome Section -->
<section x-data="{ inView: true }" 
         x-intersect="inView = true"
         :class="{'opacity-0 translate-y-10': !inView, 'opacity-100 translate-y-0': inView}"
         class="transition-all duration-1000 py-6 md:py-8 bg-white">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
            <div>
            <h2 class="text-3xl md:text-4xl lg:text-5xl font-bold text-gray-900 mb-4">Welcome to ENT Care Center</h2>
            <p class="text-base md:text-lg text-gray-600 mb-3 leading-relaxed">
                    We are dedicated to providing the highest quality medical care for all ear, nose, and throat conditions. Our team of experienced specialists uses the latest technology and treatment methods to ensure the best outcomes for our patients.
                </p>
            <p class="text-sm md:text-base text-gray-500 mb-3">
                With years of experience and a patient-first approach, we strive to make your healthcare journey as comfortable and effective as possible. We understand that every patient is unique, and we tailor our treatments to meet your specific needs.
            </p>
            <p class="text-sm md:text-base text-gray-500 mb-6">
                    Our state-of-the-art facility is equipped with advanced diagnostic and treatment equipment, allowing us to provide comprehensive ENT care under one roof. From routine check-ups to complex surgical procedures, we are committed to delivering exceptional healthcare services.
                </p>
                <a href="<?php echo e(route('about')); ?>" 
                   class="inline-block px-8 py-3 bg-gradient-to-r from-blue-600 to-purple-600 text-white rounded-full font-semibold hover:shadow-lg transform hover:scale-105 transition-all duration-300">
                    Learn More About Us
                </a>
            </div>
            <div class="relative">
                <div class="aspect-w-16 aspect-h-12 rounded-2xl overflow-hidden shadow-2xl">
                    <img src="<?php echo e(asset('img/doctor.png')); ?>" alt="ENT Care Center" class="w-full h-full object-cover">
                </div>
                <div class="absolute -bottom-6 -right-6 w-32 h-32 bg-gradient-to-br from-blue-500 to-purple-500 rounded-2xl opacity-20 blur-2xl"></div>
            </div>
        </div>
    </div>
</section>

<!-- Services Preview -->
<section x-data="{ inView: true }" 
         x-intersect="inView = true"
         class="py-20 bg-secondary-50">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-16">
            <h2 class="text-3xl md:text-4xl font-bold text-secondary-900 mb-4 tracking-tight">Our Services</h2>
            <p class="text-lg text-secondary-600 max-w-2xl mx-auto font-light">Comprehensive ENT care for all your needs. We offer a wide range of specialized services to diagnose and treat various ear, nose, and throat conditions.</p>
        </div>
        
        <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-8">
            <?php $__empty_1 = true; $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <div x-data="{ hover: false }"
                 @mouseenter="hover = true"
                 @mouseleave="hover = false"
                 class="bg-white rounded-2xl p-8 border border-secondary-100 shadow-sm hover:shadow-soft hover:-translate-y-1 transition-all duration-300 group cursor-pointer"
                 onclick="window.location.href='<?php echo e(route('services.show', $service->slug)); ?>'">
                <div class="w-14 h-14 bg-primary-50 rounded-xl flex items-center justify-center mb-6 text-primary-600 group-hover:bg-primary-600 group-hover:text-white transition-all duration-300">
                    <?php if($service->icon): ?>
                        <i class="<?php echo e($service->icon); ?> text-2xl"></i>
                    <?php else: ?>
                        <?php
                            $iconPath = match($service->name) {
                                'Hearing Evaluation' => 'M15.536 8.464a5 5 0 010 7.072m2.828-9.9a9 9 0 010 12.728M5.586 15H4a1 1 0 01-1-1v-4a1 1 0 011-1h1.586l4.707-4.707C10.923 3.663 12 4.109 12 5v14c0 .891-1.077 1.337-1.707.707L5.586 15z',
                                'Voice & Swallowing Disorders' => 'M19 11a7 7 0 01-7 7m0 0a7 7 0 01-7-7m7 7v4m0 0H8m4 0h4m-4-8a3 3 0 01-3-3V5a3 3 0 116 0v6a3 3 0 01-3 3z',
                                'Sinus Treatment' => 'M14.828 14.828a4 4 0 01-5.656 0M9 10h.01M15 10h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z',
                                'Allergy Testing & Treatment' => 'M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z',
                                'Ear Surgery' => 'M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-3 7h3m-3 4h3m-6-4h.01M9 16h.01',
                                'Tonsillectomy & Adenoidectomy' => 'M10 14l2-2m0 0l2-2m-2 2l-2-2m2 2l2 2m7-2a9 9 0 11-18 0 9 9 0 0118 0z',
                                default => 'M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z'
                            };
                        ?>
                        <svg class="w-7 h-7" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="<?php echo e($iconPath); ?>"></path>
                        </svg>
                    <?php endif; ?>
                </div>
                <h3 class="text-xl font-bold text-secondary-900 mb-3 group-hover:text-primary-600 transition-colors"><?php echo e($service->name); ?></h3>
                <p class="text-secondary-600 mb-4 line-clamp-3 leading-relaxed"><?php echo e($service->description); ?></p>
                <a href="<?php echo e(route('services.show', $service->slug)); ?>" 
                   class="inline-flex items-center text-primary-600 font-semibold group-hover:gap-2 transition-all">
                    Learn More
                    <svg class="w-4 h-4 ml-1 transform group-hover:translate-x-1 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                    </svg>
                </a>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="col-span-full text-center py-12">
                <p class="text-secondary-500 text-lg">Services coming soon...</p>
            </div>
            <?php endif; ?>
        </div>
        
        <div class="text-center mt-12">
            <a href="<?php echo e(route('services.index')); ?>" 
               class="inline-block px-8 py-3 bg-white text-secondary-700 border border-secondary-200 rounded-lg font-medium hover:border-primary-200 hover:text-primary-600 hover:bg-primary-50 transition-all duration-300 shadow-sm hover:shadow-md">
                View All Services
            </a>
        </div>
    </div>
</section>

<!-- Why Choose Us -->
<section x-data="{ inView: true }" 
         x-intersect="inView = true"
         class="transition-all duration-1000 py-6 md:py-8 bg-white">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-6 md:mb-8">
            <h2 class="text-3xl md:text-4xl lg:text-5xl font-bold text-gray-900 mb-3">Why Choose ENT Care Center?</h2>
            <p class="text-base md:text-lg text-gray-600 max-w-2xl mx-auto">We are committed to providing exceptional healthcare with a focus on patient comfort, advanced technology, and personalized care.</p>
        </div>
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4 md:gap-6">
            <div class="flex flex-col items-start space-y-3 group p-4 md:p-6 rounded-2xl hover:bg-gray-50 transition-colors">
                <div class="w-12 h-12 md:w-14 md:h-14 bg-green-100 rounded-xl flex items-center justify-center group-hover:bg-green-500 transition-colors">
                    <svg class="w-7 h-7 text-green-600 group-hover:text-white transition-colors" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                    </svg>
                </div>
                <div>
                    <h3 class="font-bold text-lg text-gray-900 mb-2">Experienced Specialists</h3>
                    <p class="text-gray-600 text-sm md:text-base">Board-certified specialists with years of experience in treating complex ENT conditions. Our doctors stay updated with the latest medical advancements.</p>
                </div>
            </div>
            <div class="flex flex-col items-start space-y-3 group p-4 md:p-6 rounded-2xl hover:bg-gray-50 transition-colors">
                <div class="w-12 h-12 md:w-14 md:h-14 bg-blue-100 rounded-xl flex items-center justify-center group-hover:bg-blue-500 transition-colors">
                    <svg class="w-6 h-6 md:w-7 md:h-7 text-blue-600 group-hover:text-white transition-colors" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                    </svg>
                </div>
                <div>
                    <h3 class="font-bold text-base md:text-lg text-gray-900 mb-1">State-of-the-Art Equipment</h3>
                    <p class="text-gray-600 text-xs md:text-sm">Latest medical technology for accurate diagnosis and effective treatment. We invest in cutting-edge equipment to ensure the best patient outcomes.</p>
                </div>
            </div>
            <div class="flex flex-col items-start space-y-3 group p-4 md:p-6 rounded-2xl hover:bg-gray-50 transition-colors">
                <div class="w-12 h-12 md:w-14 md:h-14 bg-purple-100 rounded-xl flex items-center justify-center group-hover:bg-purple-500 transition-colors">
                    <svg class="w-6 h-6 md:w-7 md:h-7 text-purple-600 group-hover:text-white transition-colors" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                    </svg>
                </div>
                <div>
                    <h3 class="font-bold text-base md:text-lg text-gray-900 mb-1">Patient-Centered Care</h3>
                    <p class="text-gray-600 text-xs md:text-sm">Personalized treatment plans for each patient. We take time to understand your concerns and develop customized solutions that work for you.</p>
                </div>
            </div>
            <div class="flex flex-col items-start space-y-3 group p-4 md:p-6 rounded-2xl hover:bg-gray-50 transition-colors">
                <div class="w-12 h-12 md:w-14 md:h-14 bg-pink-100 rounded-xl flex items-center justify-center group-hover:bg-pink-500 transition-colors">
                    <svg class="w-6 h-6 md:w-7 md:h-7 text-pink-600 group-hover:text-white transition-colors" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                    </svg>
                </div>
                <div>
                    <h3 class="font-bold text-base md:text-lg text-gray-900 mb-1">Comprehensive Treatment</h3>
                    <p class="text-gray-600 text-xs md:text-sm">Full range of ENT services under one roof. From diagnosis to treatment and follow-up care, we provide complete healthcare solutions.</p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Doctors Preview -->
<?php if($doctors->count() > 0): ?>
<section x-data="{ inView: true }" 
         x-intersect="inView = true"
         class="py-6 md:py-8 bg-gradient-to-br from-gray-50 to-blue-50">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-6 md:mb-8">
            <h2 class="text-3xl md:text-4xl lg:text-5xl font-bold text-gray-900 mb-3">Our Expert Doctors</h2>
            <p class="text-base md:text-lg text-gray-600 max-w-2xl mx-auto">Meet our team of experienced specialists dedicated to providing you with the best ENT care.</p>
        </div>
        
        <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-4 md:gap-6">
            <?php $__currentLoopData = $doctors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $doctor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div x-data="{ hover: false }"
                 @mouseenter="hover = true"
                 @mouseleave="hover = false"
                 x-init="$el.style.opacity = '1'; $el.style.transform = 'translateY(0)';"
                 x-intersect="if ($el.style.opacity === '1') { $el.style.opacity = '0'; $el.style.transform = 'translateY(30px)'; setTimeout(() => { $el.style.transition = 'all 0.6s ease-out'; $el.style.opacity = '1'; $el.style.transform = 'translateY(0)'; }, <?php echo e($index * 150); ?>); }"
                 class="bg-white rounded-2xl overflow-hidden shadow-lg hover:shadow-2xl transform hover:-translate-y-2 transition-all duration-300 group">
                <div class="relative h-72 md:h-80 overflow-hidden bg-secondary-50">
                    <?php if($doctor->image): ?>
                        <img src="<?php echo e(asset('storage/' . $doctor->image)); ?>" 
                             alt="<?php echo e($doctor->name); ?>" 
                             class="w-full h-full object-contain object-center origin-top transform group-hover:scale-110 transition-transform duration-500">
                    <?php else: ?>
                        <div class="w-full h-full bg-gradient-to-br from-blue-400 to-purple-500 flex items-center justify-center">
                            <svg class="w-24 h-24 text-white opacity-50" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M10 9a3 3 0 100-6 3 3 0 000 6zm-7 9a7 7 0 1114 0H3z" clip-rule="evenodd"></path>
                            </svg>
                        </div>
                    <?php endif; ?>
                    <div class="absolute inset-0 bg-gradient-to-t from-black/60 to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-300"></div>
                </div>
                <div class="p-4 md:p-6">
                    <h3 class="text-lg md:text-xl font-bold text-gray-900 mb-1"><?php echo e($doctor->name); ?></h3>
                    <p class="text-blue-600 font-semibold mb-1 text-sm md:text-base"><?php echo e($doctor->specialization); ?></p>
                    <p class="text-xs md:text-sm text-gray-500 mb-3"><?php echo e($doctor->credentials); ?></p>
                    <?php if($doctor->bio): ?>
                    <p class="text-sm md:text-base text-gray-600 mb-3 line-clamp-3"><?php echo e(Str::limit($doctor->bio, 120)); ?></p>
                    <?php endif; ?>
                    <?php if($doctor->experience_years > 0): ?>
                    <div class="flex items-center text-gray-600 text-sm md:text-base">
                        <svg class="w-5 h-5 mr-2 text-yellow-500" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                        </svg>
                        <span><?php echo e($doctor->experience_years); ?> years of experience</span>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
        
        <div class="text-center mt-12">
            <a href="<?php echo e(route('about')); ?>" 
               class="inline-block px-8 py-3 bg-gradient-to-r from-blue-600 to-purple-600 text-white rounded-full font-semibold hover:shadow-lg transform hover:scale-105 transition-all duration-300">
                View All Doctors
            </a>
        </div>
    </div>
</section>
<?php endif; ?>

<!-- Testimonials Carousel -->
<?php if($testimonials->count() > 0): ?>
<section x-data="{
    currentSlide: 0,
    slides: <?php echo e($testimonials->count()); ?>,
    next() {
        this.currentSlide = (this.currentSlide + 1) % this.slides;
    },
    prev() {
        this.currentSlide = (this.currentSlide - 1 + this.slides) % this.slides;
    },
    goToSlide(index) {
        this.currentSlide = index;
    }
}" 
         x-init="setInterval(() => next(), 5000)"
         class="py-6 md:py-8 bg-gradient-to-br from-blue-600 via-purple-600 to-pink-500 text-white">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-6 md:mb-8">
            <h2 class="text-3xl md:text-4xl lg:text-5xl font-bold mb-3">What Our Patients Say</h2>
            <p class="text-base md:text-lg text-white/90">Trusted by thousands of satisfied patients</p>
        </div>
        
        <div class="relative">
            <div class="overflow-hidden rounded-2xl">
                <div class="flex transition-transform duration-500 ease-in-out" 
                     :style="`transform: translateX(-${currentSlide * 100}%)`">
                    <?php $__currentLoopData = $testimonials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $testimonial): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="min-w-full px-4 md:px-8 py-6 md:py-8">
                        <div class="max-w-3xl mx-auto text-center">
                            <div class="flex justify-center mb-6">
                                <?php for($i = 0; $i < $testimonial->rating; $i++): ?>
                                <svg class="w-5 h-5 md:w-6 md:h-6 text-yellow-300" fill="currentColor" viewBox="0 0 20 20">
                                    <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                                </svg>
                                <?php endfor; ?>
                            </div>
                            <p class="text-lg md:text-xl lg:text-2xl font-light mb-6 leading-relaxed px-4">"<?php echo e($testimonial->content); ?>"</p>
                            <div>
                                <p class="text-lg md:text-xl font-semibold mb-1"><?php echo e($testimonial->author); ?></p>
                                <?php if($testimonial->position): ?>
                                <p class="text-white/80 text-sm md:text-base"><?php echo e($testimonial->position); ?></p>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
            
            <!-- Navigation buttons -->
            <button @click="prev()" 
                    class="absolute left-2 md:left-4 top-1/2 transform -translate-y-1/2 bg-white/20 hover:bg-white/30 rounded-full p-2 md:p-3 transition-all">
                <svg class="w-5 h-5 md:w-6 md:h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path>
                </svg>
            </button>
            <button @click="next()" 
                    class="absolute right-2 md:right-4 top-1/2 transform -translate-y-1/2 bg-white/20 hover:bg-white/30 rounded-full p-2 md:p-3 transition-all">
                <svg class="w-5 h-5 md:w-6 md:h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                </svg>
            </button>
            
            <!-- Dots indicator -->
            <div class="flex justify-center mt-8 space-x-2">
                <?php $__currentLoopData = $testimonials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $testimonial): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <button @click="goToSlide(<?php echo e($index); ?>)" 
                        :class="{'bg-white': currentSlide === <?php echo e($index); ?>, 'bg-white/30': currentSlide !== <?php echo e($index); ?>}"
                        class="w-2 h-2 md:w-3 md:h-3 rounded-full transition-all"></button>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>
</section>
<?php endif; ?>

<!-- CTA Section -->
<section x-data="{ inView: true }" 
         x-intersect="inView = true"
         :class="{'opacity-0 scale-95': !inView, 'opacity-100 scale-100': inView}"
         class="transition-all duration-1000 py-20 bg-primary-600 text-white overflow-hidden relative">
    <!-- Decorative patterns -->
    <div class="absolute top-0 right-0 -mr-20 -mt-20 w-80 h-80 rounded-full bg-primary-500 opacity-20 blur-3xl"></div>
    <div class="absolute bottom-0 left-0 -ml-20 -mb-20 w-80 h-80 rounded-full bg-primary-700 opacity-20 blur-3xl"></div>
    
    <div class="relative z-10 max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
        <h2 class="text-3xl md:text-5xl font-bold mb-6 tracking-tight">Ready to Schedule Your Appointment?</h2>
        <p class="text-lg md:text-xl mb-10 text-primary-100 px-4 font-light">Contact us today to book your consultation with our expert ENT specialists. We're here to help you achieve better health.</p>
        <div class="flex flex-col sm:flex-row gap-5 justify-center">
            <a href="<?php echo e(route('appointment.create')); ?>" 
               class="px-8 py-4 bg-white text-primary-600 rounded-xl font-bold text-lg shadow-xl hover:shadow-2xl hover:-translate-y-1 transition-all duration-300">
                Book Appointment
            </a>
            <a href="<?php echo e(route('contact.index')); ?>" 
               class="px-8 py-4 bg-primary-700 border border-primary-500 text-white rounded-xl font-bold text-lg hover:bg-primary-800 hover:border-primary-600 transition-all duration-300">
                Contact Us
            </a>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.modern', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/sumankc/Desktop/ Websites/ENT Care/resources/views/home.blade.php ENDPATH**/ ?>